<?php if(is_sales_man_user() === true){ ?>
  <style type="text/css">
    .navbar-default.navbar-static-side{display: none !important;}
    #page-wrapper{width: 100%; margin: 0;}
    .footer.fixed{margin: 0;}
  </style>
<?php } ?>

<?php if(is_sales_man_user() === false AND is_marketer_user() === false){ ?>
    <div class="row wrapper border-bottom white-bg page-heading">
        <div class="col-lg-10">
            <h2><?= $breadcrums_title; ?></h2>
            <ol class="breadcrumb">
                <li>
                    <a class="url-elem" href="<?php echo url('/dashboard'); ?>"><?= print_lang($app_lang,'home'); ?></a>
                </li>
                <li>
                    <a class="url-elem" href="<?php echo url('/reports'); ?>"><?= print_lang($app_lang,'reports'); ?></a>
                </li>
                <li class="active">
                    <strong><?= $breadcrums_title; ?></strong>
                </li>
            </ol>
        </div>
        <div class="col-lg-2">
            
        </div>
    </div>
<?php } ?>


<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-content">

                    <h2 class="text-center font-bold" style="margin: 10px 0 20px;"><?= $breadcrums_title; ?> <?= print_lang($app_lang,'listing'); ?></h2>

                    <form id="client-balance-summary-search-form" action="<?= url('/client-balance-summary'); ?>">
                    <div class="row">
                        <div class="col-md-9">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group <?= $pointer; ?>">
                                        <label><?= print_lang($app_lang,'client_bal_summ_filter_type'); ?></label>
                                        <select class="form-control chosen-select" name="type_filter">
                                            <option value="all" <?php if($search_type == 'all'){echo "selected='selected'";}?>><?= print_lang($app_lang,'client_bal_summ_filter_type_all'); ?></option>
                                            <option value="category" <?php if($search_type == 'category'){echo "selected='selected'";}?>><?= print_lang($app_lang,'client_bal_summ_filter_type_category'); ?></option>
                                            <option value="sales_man" <?php if($search_type == 'sales_man'){echo "selected='selected'";}?>><?= print_lang($app_lang,'client_bal_summ_filter_type_sales_man'); ?></option>
                                            <option value="marketer" <?php if($search_type == 'marketer'){echo "selected='selected'";}?>><?= print_lang($app_lang,'client_bal_summ_filter_type_marketer'); ?></option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-3">
                                    <div class="form-group <?= $pointer; ?>">
                                        <label><?= print_lang($app_lang,'client_bal_summ_filter_by'); ?></label>
                                        <select class="form-control chosen-select" name="filter_by">
                                            <option value="">--<?= print_lang($app_lang,'client_bal_summ_filter_by'); ?>--</option>
                                            <?php foreach($filter_by_type as $row){
                                                if($search_type == 'sales_man' OR $search_type == 'marketer'){$name = $row['name'].' '.$row['last_name'];}else{$name = $row['name'];}
                                            ?>
                                                <option value="<?= $row['uid']; ?>" <?php if($search_filter_by == $row['uid']){echo "selected='selected'";}?>><?= $name; ?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>

                                
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'from'); ?></label>
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_from; ?>" name="from" placeholder="<?= print_lang($app_lang,'from'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="from" value="<?= $search_from; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label><?= print_lang($app_lang,'to'); ?></label>
                                        <?php if($branch_calander == 'persian'){ ?>
                                            <input type="text" class="form-control persian-date" value="<?= $search_to; ?>" name="to" placeholder="<?= print_lang($app_lang,'to'); ?>" readonly="" style="background: #fff;">
                                        <?php }else{ ?>
                                            <input type="date" class="form-control" name="to" value="<?= $search_to; ?>">
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 text-right" style="margin-top: 23px;">
                            <button class="btn btn-w-m btn-primary custom-font-btn-search" type="submit"><?= print_lang($app_lang,'search'); ?></button>
                            <a target="_blank" href="<?= url('/client-balance-summary-print').'?'.'type_filter='.$search_type.'&filter_by='.$search_filter_by.'&from='.$search_from.'&to='.$search_to.'&account='.$search_account.''; ?>" class="btn btn-outline btn-primary dim"><i class="fa fa-print"></i></a>
                        </div>
                    </div>
                    </form>
                    <hr>

                    <div class="table-responsive">
                        <table class="table table-bordered table-hover dataTables-view">
                            <thead>
                                <tr>
                                    <th class="text-center"><?= print_lang($app_lang,'sr_#'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'client_balance_summary_client_name'); ?></th>
                                    <th class="text-center"><?= print_lang($app_lang,'client_balance_summary_client_mobile'); ?></th>
                                    <?php
                                    $for_totals = array();
                                    foreach($currencies as $row){
                                        $for_totals[$row['uid']] = array('debit' => array(), 'credit' => array());
                                    ?>
                                        <th class="text-center"><?= print_lang($app_lang,'balance'); ?> (<?= $row['name']; ?>)</th>
                                    <?php } ?>
                                </tr>
                            </thead>
                            <tbody>
                                
                                <?php $balance_color = '#ec4758'; if(count($accounts) > 0){ ?>
                                    <?php $i = 1; foreach($accounts as $row){ ?>
                                        <tr class="text-center">
                                            <td><?= $i++; ?></td>
                                            <td><?= $row['name']; ?></td>
                                            <td><?= $row['mobile']; ?></td>
                                            
                                            <?php
                                            foreach($currencies as $cur_row){
                                                $currency_account_ledgers = 100;
                                                // if($row['shared'] == 'yes')
                                                // {
                                                //     $balance = fetch_shared_account_balance($row['uid'],$cur_row['uid'],'client',$search_from,$search_to);
                                                // }
                                                // else
                                                // {
                                                //     $balance = fetch_account_balance($row['uid'],$cur_row['uid'],'client',$search_from,$search_to);
                                                // }
                                                $balance = fetch_account_balance($row['uid'],$cur_row['uid'],'client',$search_from,$search_to);
                                                if($balance >= 0)
                                                {
                                                    if(array_key_exists($cur_row['uid'],$for_totals)){ $for_totals[$cur_row['uid']]['debit'][] = abs($balance); }
                                                    $balance = amount_number_format(abs($balance)).' DR';
                                                    $balance_color = '#2B9C1B';
                                                }
                                                else
                                                {
                                                    if(array_key_exists($cur_row['uid'],$for_totals)){ $for_totals[$cur_row['uid']]['credit'][] = abs($balance); }
                                                    $balance = amount_number_format(abs($balance)).' CR';
                                                    $balance_color = '#ec4758';
                                                }
                                            ?>
                                                <td style="color: <?= $balance_color; ?>;"><?= $balance; ?></td>
                                            <?php } ?>

                                        </tr>
                                    <?php  } ?>

                                    <tr class="text-center">
                                        <td></td>
                                        <td><strong><?= print_lang($app_lang,'total'); ?></strong></td>
                                        <td></td>
                                        <?php
                                        foreach($for_totals as $row){
                                            $total_debit = array_sum($row['debit']);
                                            $total_credit = array_sum($row['credit']);
                                            if($total_debit >= $total_credit)
                                            {
                                                $total = amount_number_format( $total_debit - $total_credit ).' DR';
                                                $balance_color = '#2B9C1B';
                                            }
                                            else
                                            {
                                                $total = amount_number_format( $total_credit - $total_debit ).' CR';
                                                $balance_color = '#ec4758';
                                            }
                                        ?>
                                            <td style="color: <?= $balance_color; ?>;"><strong><?= $total; ?></strong></td>
                                        <?php } ?>
                                    </tr>

                                <?php } ?>

                            </tbody>
                        </table>    
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>